create or replace function tbicds.HasUserRight(pi_nUserID in number, pi_nUserRight in binary_integer) return boolean
AUTHID CURRENT_USER
is
   v_vSql                               varchar2(4000);
   v_bResult                            boolean;
   v_nUserRights                        binary_integer;
   v_nHasRight                          binary_integer;
begin
   v_nUserRights := 0;
   v_nHasRight := 0;

   begin
      v_vSql := 'select nvl(user_rights, 0) from tbicds.fx_user_rights t where t.fx_user_id = :P0';
      execute immediate v_vSql into v_nUserRights using pi_nUserID;
   exception
      when others then
         return false;
   end;
  
   v_nHasRight := bitand(v_nUserRights, pi_nUserRight);
  
   if v_nHasRight > 0 then
      v_bResult := true;
   else
      v_bResult := false;
   end if;
    
   return v_bResult;
end;
/

